unit Printcap;

interface

uses 
     SysUtils,
     WinTypes, 
     WinProcs, 
     Classes, 
     Graphics, 
     Forms, 
     Controls, 
     Buttons,
     StdCtrls, 
     Spin, 
     ExtCtrls, 
     nwPrint, 
     Nwtools, 
     Nwlib, 
     NWServer;

type
  TwinCapture = class(TForm)
    OKBtn: TBitBtn;
    CancelBtn: TBitBtn;
    Panel1: TPanel;
    Header1: THeader;
    ServerList: TListBox;
    Panel2: TPanel;
    Header2: THeader;
    QueueList: TListBox;
    Bevel1: TBevel;
    Bevel2: TBevel;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    cBanner: TEdit;
    nCopies: TSpinEdit;
    nTimeOut: TSpinEdit;
    nTabs: TSpinEdit;
    lAutoEndCap: TCheckBox;
    bEndCap: TButton;
    Label5: TLabel;
    lFormFeeds: TCheckBox;
    NWLib1: TNWLib;
    NWTools1: TNWTools;
    NWPrint1: TNWPrint;
    NWServer1: TNWServer;
    Panel3: TPanel;
    Header3: THeader;
    qUserList: TListBox;
    Panel4: TPanel;
    Header4: THeader;
    qOperatorList: TListBox;
    Panel5: TPanel;
    Header5: THeader;
    qServerList: TListBox;
    bQueue: TButton;
    formName: TEdit;
    procedure FormShow(Sender: TObject);
    procedure ServerListDblClick(Sender: TObject);
    procedure OKBtnClick(Sender: TObject);
    procedure bEndCapClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure QueueListDblClick(Sender: TObject);
    procedure QueueListClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  winCapture: TwinCapture;

implementation

{$R *.DFM}

uses
  list ;

{ Store Capture Options }
var
  captureFlags : TNWCaptureFlags ; 

procedure TwinCapture.FormCreate(Sender: TObject);
  begin
    { get current capture environment} 
    if (not getCaptureFlags(1,captureFlags)) and
       (not getCaptureFlags(2,captureFlags)) and
       (not getCaptureFlags(3,captureFlags)) then
      okBox('No Printer Ports are Redirected to Network Devices') ;
  end;

procedure TwinCapture.FormShow(Sender: TObject);
  begin
    { Populate Listboxes }
    serverList.items.AddStrings(
                      getConnectedServerList) ;
    queueList.items.AddStrings(
                      getBinderyList(getPrimaryServerID,nw_printq)) ;
    qServerList.items.AddStrings(
                      getQueueServers(getPrimaryServerID,captureFlags.qname)) ;
    qUserList.items.AddStrings(
                      getQueueUsers(getPrimaryServerID,captureFlags.qname)) ;
    qOperatorList.items.AddStrings(
                      getQueueOperators(getPrimaryServerID,captureFlags.qname)) ;
    bEndCap.enabled := IsCaptured(1) ; { LPT1: }                               
    { Read Capture Flags }
    nCopies.value  := captureFlags.Copies ;
    nTabs.value    := captureFlags.tabSize ;
    nTimeOut.value := captureFlags.timeout ;
    cBanner.text   := captureFlags.banner ;
    formName.text  := captureFlags.formName ;
    lAutoEndCap.checked := captureFlags.autoEndCap ;
    lFormFeeds.checked  := captureFlags.FormFeed ;

    { Set Listbox indexes }
    serverlist.itemindex := 
         serverList.items.indexOf(getServerName(captureFlags.nServer));
    queuelist.itemindex := 
         queuelist.items.indexOf(captureFlags.qname) ;
  end;

procedure TwinCapture.ServerListDblClick(Sender: TObject);
  var
    nconn : TNWConnHandle ;
    ctemp : string ;
  begin
    { Select New Server and Build New Queue List}
    if (serverList.items.count > 0) then
      begin
        ctemp := serverList.items[serverList.itemindex] ;
        nConn := getServerHandle(ctemp) ;
        if nConn > 0 then
          begin
            queueList.clear ;
            queueList.items.addStrings(getBinderyList(nConn,nw_printq));
          end
      end;
  end;

procedure TwinCapture.OKBtnClick(Sender: TObject);
  var
    cserver  : string ;
    cqueue   : string ;
  begin     
    if (queueList.items.count < 1) or (serverList.items.count < 1) then
      exit ;    
    if (serverList.itemIndex < 0) then
      serverList.itemIndex := 0 ;
    if (queueList.itemIndex < 0) then
      queueList.itemIndex := 0 ;
    cserver := serverList.items[serverList.itemindex] ;
    cqueue  := queueList.items[queueList.itemindex] ;
    { seed the captureFlags structure }
    with captureFlags do begin
      copies     := nCopies.value ;
      banner     := cbanner.text ;
      tabSize    := nTabs.value ;
      timeOut    := nTimeOut.value ;
      formName   := self.formName.text ;
      autoEndCap := lAutoEndCap.checked;
      formFeed   := lFormFeeds.checked ;
    end;
   if capture(getServerHandle(cserver),cQueue,1,captureFlags) then 
      begin
        bEndCap.enabled := True ;
        okBox(cserver +'/' + cqueue + ';Captured Successfully!') ;
      end
    else
      alertBox('Error Capturing LPT1: to Device ' +
               queueList.items[MaxLong(queuelist.itemIndex,0)]) ;        
  end;

procedure TwinCapture.bEndCapClick(Sender: TObject);
  begin
    bEndCap.enabled := (not EndCap(1)) ;
  end;

procedure TwinCapture.QueueListDblClick(Sender: TObject);
  var
    jobList : TStringList ;
  begin
    if (queueList.items.count > 0) then
      begin
        if (queueList.itemIndex < 0) then
          queueList.itemIndex := 0 ;
        {show print queue jobs}
        try
          application.createForm(TWinList,winList) ;
          winList.inServer := getServerHandle(serverList.items[serverList.itemIndex]);
          winList.inQueue  := getObjNumber(winList.inServer,
                                           queueList.items[queueList.itemIndex],
                                           nw_printQ) ;
          { set the list form's onShow event }
          winList.onShow   := winList.onPrintJobsShow ;
          winList.showModal ;
        finally
          winList.free ;
        end;
      end;  
  end;

procedure TwinCapture.QueueListClick(Sender: TObject);
  var
    jobList : TStringList ;
  begin
    if (queueList.items.count > 0) then
      begin
        qUserList.items.clear ;
        qUserList.items.AddStrings(
            getQueueUsers(getPrimaryServerID,queueList.items[queueList.itemIndex])) ;

        qOperatorList.items.clear ;
        qOperatorList.items.AddStrings(
            getQueueOperators(getPrimaryServerID,queueList.items[queueList.itemIndex])) ;

        qServerList.items.clear ;
        qServerList.items.AddStrings(
            getQueueServers(getPrimaryServerID,queueList.items[queueList.itemIndex])) ;
      end;  
  end;

end.
